fkk = fkk or {}
fkk.lib = fkk.lib or {}

fkk.lib.math = fkk.lib.math or {
        round = function (real, digits)
                digits = digits or 0
                digits = 1 / math.pow (10, digits)
                local remainder = math.mod (real, digits)
                if remainder / digits < 0.5 then
                        return real - remainder
                end
                return real - remainder + (digits)
        end,
        dec2bin = function (iDec)
                local iMax = 0
                local sBin = ""

                while true do
                        iMax = iMax + 1
                        if math.pow (2, iMax) > iDec then
                                sBin = string.rep ("0", iMax)
                                iMax = math.pow (2, iMax)
                                break
                        end
                end

                for pos = 1, string.len (sBin) do
                        if iDec >= math.pow (2, string.len (sBin) - pos, 2)then
                                sBin = string.sub (sBin, 1, pos - 1) .. "1" .. string.sub (sBin, pos + 1)
                                iDec = iDec - math.pow (2, string.len (sBin) - pos)
                        end
                end

                return sBin
        end,
        bin2dec = function (sBin)
                sBin = tostring (sBin)
                if string.find (sBin, "[^10]") then
                        return false, sBin .. " is not a valid binary format"
                end

                while string.sub (sBin, 1, 1) == "0" do
                        sBin = string.sub (sBin, 2)
                end
                sBin = fkk.lib.string.reverse (sBin)

                local iDec = 0
                for pos = 2, string.len (sBin) do
                        if string.sub (sBin, pos, pos) == "1" then
                                iDec = iDec + math.pow (2, pos - 1)
                        end
                end
                if string.sub (sBin, 1, 1) == "1" then
                        iDec = iDec + 1
                end
                return iDec
        end,
        hex2rgb = function (sStr)
                if not is_string (sStr) then
                        return false, "hex2rgb: argument needs to be a string."
                end
                if string.sub (sStr, 1, 1) == "#" then
                        sStr = string.sub (sStr, 2)
                end
                if not is_hex (sStr) then
                        return false, "hex2rgb: argument is not a hex-string."
                end

                while string.len (sStr) < 6 do
                        sStr = "0" .. sStr
                end
                return {
                        tonumber (string.sub (sStr, 1, 2), 16),
                        tonumber (string.sub (sStr, 3, 4), 16),
                        tonumber (string.sub (sStr, 5, 6), 16)
                }
        end,
        rgb2hex = function (r, g, b)
                if not is_rgb (r, g, b) then
                        return false, "rgb2hex: expecting 3 integers between 0 and 255"
                end
                return string.format ("%02X%02X%02X", r, g, b)
        end,
        gradient = function (amount, ...)
                if arg.n <= 1 then
                        return false, "gradtient: Needs at least 2 colorvalues"
                elseif not is_integer (amount) then
                        return false, "gradtient: argument #1 needs to be an integer."
                end
                for i,_ in ipairs (arg) do
                        if is_hex (string.sub (arg[i], -6)) then
                                arg[i], err = fkk.lib.math.hex2rgb (arg[i])
                                if err ~= nil then
                                        return false, "gradient: " .. err
                                end
                        end
                        if not is_rgb (unpack (arg[i])) then
                                return false, "gradtient: argument #" .. (i + 1) .. " is not a valid color code (rgb/hex)."
                        end
                end

                amount = amount
                local colors, steps = {}, math.floor (amount / (arg.n - 1))
                local rest = math.mod (amount, (steps * (arg.n - 1)))
                local col = {from, to, cur = {}}

                for i = 1, arg.n - 1 do
                        col.from = arg[i]
                        col.to = arg[i + 1]

                        table.insert (colors, col.from)

                        if i == arg.n - 1 then
                                steps = steps + rest
                        end
                        for step = 1, steps - 1 do
                                --print (step)
                                for c = 1, 3 do
                                        col.cur[c] = math.ceil (col.from[c] + ((col.to[c] - col.from[c]) / steps) * step)
                                end
                                table.insert (colors, col.cur)
                                col.cur = {}
                        end
                end
                return colors
        end
}
